//  Copyright 2019 mobileknowledge. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "NTAG5_NFC_LIB.h"
#import "Config.h"
#import "I2CMasterChannelUseCase.h"
#import "RFCommands.h"
#import "Utils.h"

NS_ASSUME_NONNULL_BEGIN

@interface i2cMasterChannelViewController : UIViewController

/* VARS */
@property (assign) BOOL                     isDefaultCommands;

/* UI IMAGE VIEWS */
@property (weak,nonatomic)    IBOutlet      UIImageView *checkBox1;
@property (weak,nonatomic)    IBOutlet      UIImageView *checkBox2;
@property (strong, nonatomic) IBOutlet      UIImageView *downIcon;
@property (strong, nonatomic) IBOutlet      UIImageView *writeComandImage;

/* UI TEXT VIEWS */
@property (weak,nonatomic)    IBOutlet      UITextView *textView1;
@property (weak,nonatomic)    IBOutlet      UITextView *textView2;
@property (weak, nonatomic)   IBOutlet      UITextView *defaultCommandsTextView;
@property (weak, nonatomic)   IBOutlet      UITextView *logsTextView;
@property (weak, nonatomic)   IBOutlet      UITextView *commLogText;
@property (strong, nonatomic) IBOutlet      UITextView *howToWriteCommandTitle;

/* UI LABELS */
@property (strong, nonatomic) IBOutlet      UILabel *listTitle;

/* UI TEXTFIELDS */
@property (weak, nonatomic)   IBOutlet      UITextField *writeCommandTextField;

/* UI BUTTONS */
@property (strong, nonatomic) IBOutlet      UIButton *sendCommandButton;

/* UI VIEWS */
@property (strong, nonatomic) IBOutlet      UIView *defaultCommands;
@property (weak, nonatomic)   IBOutlet      UIView *defaultCommandsList;
@property (weak, nonatomic)   IBOutlet      UIView *configsensorOption;
@property (weak, nonatomic)   IBOutlet      UIView *getTemperatureOption;
@property (weak, nonatomic)   IBOutlet      UIView *getAccXOption;
@property (weak, nonatomic)   IBOutlet      UIView *getAccYOption;
@property (weak, nonatomic)   IBOutlet      UIView *getAccZOption;
@property (weak, nonatomic)   IBOutlet      UIView *getMagXOption;
@property (weak, nonatomic)   IBOutlet      UIView *getMagYOption;
@property (weak, nonatomic)   IBOutlet      UIView *getMagZOption;
@property (weak, nonatomic)   IBOutlet      UIView *configDropDownList;
@property (strong, nonatomic) IBOutlet      UIView *MainView;
@property (weak, nonatomic) IBOutlet UIButton *configSensorButton;
@property (weak, nonatomic) IBOutlet UIButton *getTempButton;
@property (weak, nonatomic) IBOutlet UIButton *getAccXButton;
@property (weak, nonatomic) IBOutlet UIButton *getAccYButton;
@property (weak, nonatomic) IBOutlet UIButton *getAccZButton;

/* UI BAR BUTTONS */
@property (weak, nonatomic)   IBOutlet      UIBarButtonItem *navBarButton;

/* GESTURE & TAP RECOGNIZERS */
- (void)handleSingleTap:                    (UITapGestureRecognizer *)recognizer;
- (IBAction)checkbox1Tap:                   (UIGestureRecognizer *)sender;
- (IBAction)checkbox2Tap:                   (UIGestureRecognizer *)sender;
- (IBAction)checkbox1TextTap:               (UIGestureRecognizer *)sender;
- (IBAction)checkbox2TextTap:               (UIGestureRecognizer *)sender;
- (IBAction)defaultCommandsDropDownTap:     (UIGestureRecognizer *)sender;
- (IBAction)configureOptionSelected:        (UIGestureRecognizer *)sender;
- (IBAction)getTempOptionSelected:          (UIGestureRecognizer *)sender;
- (IBAction)getAccXOptionSelected:          (UIGestureRecognizer *)sender;
- (IBAction)getAccYOptionSelected:          (UIGestureRecognizer *)sender;
- (IBAction)getAccZOptionSelected:          (UIGestureRecognizer *)sender;
- (IBAction)getMagXOptionSelected:          (UIGestureRecognizer *)sender;
- (IBAction)getMagYOptionSelected:          (UIGestureRecognizer *)sender;
- (IBAction)getMagZOptionSelected:          (UIGestureRecognizer *)sender;
- (IBAction)setI2cSlaveModeOptionSelected:  (UIGestureRecognizer *)sender;
- (IBAction)setI2cMasterModeOptionSelected: (UIGestureRecognizer *)sender;
- (IBAction)setGPIOPWMModeOptionSelected:   (UIGestureRecognizer *)sender;
- (IBAction)getUseCaseCongifOptionSelected: (UIGestureRecognizer *)sender;
- (IBAction)sendCommandButtonClick:         (UIButton *)sender;
- (IBAction)navBarButtonClick:              (id)sender;
- (IBAction)configSensorButtonClick:(id)sender;
- (IBAction)getTempButtonClick:(id)sender;
- (IBAction)getAccXButtonClick:(id)sender;
- (IBAction)getAccYButtonClick:(id)sender;
- (IBAction)getAccZButtonClick:(id)sender;

/* --------------------------------------- */

/*!
 *@abstract   sends the required commands depending on which default command is selected
 **/
- (void) sendDefaultCommands;

/*!
 *@abstract   Writes the logs into the I2C Master Channel View Controller
 **/
- (void) writeLog: (NSString *) cmd response: (NSData *) resp;

@end

NS_ASSUME_NONNULL_END
